﻿using NVCC.Models;
using NVCC.WebUI.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NVCC.WebUI.Infrastructure
{
    public interface IRoiService
    {
        IEnumerable<RoiSearchResult> RoiSearch(string lastFourOfSsn, string lastNamePartial, string firstFiveOfSsn = null, string firstNamePartial = null, DateTime? startDate = null, DateTime? endDate = null);
        Disclosure GetDisclosureById(int disclosureId);
        IEnumerable<ROIAdminSearch> GetRoiAdminSearchResults(short sta3n, short visn, DateTime? startDate, DateTime? endDate, string userId, int showIncompleteAOD);
        List<UserByFacility> GetUsersByFacilityId(int sta6a);
        Disclosure EditDisclosureMadeTo(Disclosure editedDisclosure, bool isRoiAdmin, string userId);
    }
}
